/* -LICENSE-START-
 ** Copyright (c) 2013 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */

#include "platform.h"

// Windows platform functions

HRESULT Initialize()
{
	HRESULT result = E_FAIL;
	result = CoInitialize(NULL);
	if (FAILED(result))
	{
		fprintf(stderr, "Initialization of COM failed - result = %08x.\n", result);
	}
	return result;
}

HRESULT GetDeckLinkIterator(IDeckLinkIterator **deckLinkIterator)
{
	HRESULT result = E_FAIL;
	
	// Create an IDeckLinkIterator object to enumerate all DeckLink cards in the system
	result = CoCreateInstance(CLSID_CDeckLinkIterator, NULL, CLSCTX_ALL, IID_IDeckLinkIterator, (void**)deckLinkIterator);
	if (FAILED(result))
	{
		fprintf(stderr, "A DeckLink iterator could not be created.  The DeckLink drivers may not be installed.\n");
		return E_FAIL;
	}
	return S_OK;
}

HRESULT GetDeckLinkDiscoveryInstance(IDeckLinkDiscovery **deckLinkDiscovery)
{
	HRESULT result = E_FAIL;
	*deckLinkDiscovery = NULL;
	
	result = CoCreateInstance(CLSID_CDeckLinkDiscovery, NULL, CLSCTX_ALL, IID_IDeckLinkDiscovery, (void**)deckLinkDiscovery);
	if (FAILED(result) || *deckLinkDiscovery == NULL)
	{
		fprintf(stderr, "A DeckLink discovery instance could not be created.\n");
		return E_FAIL;
	}
    return S_OK;
}

void MutexInit(MUTEX* mutex)
{
	*mutex = (void*)CreateMutex(NULL, false, NULL);
}

void MutexLock(MUTEX* mutex)
{
	WaitForSingleObject((HANDLE) mutex, INFINITE);
}

void MutexUnlock(MUTEX* mutex)
{
	ReleaseMutex(mutex);
}

void MutexDestroy(MUTEX* mutex)
{
	CloseHandle((HANDLE)*mutex);    
}

void StringFromCharArray(STRINGOBJ* newStr, const char* charPtr)
{
	_bstr_t tmpValue(charPtr);
	*newStr = tmpValue.copy(true);
}

void StringToCharArray(STRINGOBJ bmdStr, char* charArray, unsigned int arrayLength)
{
	_bstr_t         myBStr(bmdStr); // copies bmdStr, does not take ownership as myBStr autoreleases
	const char*     cstr = myBStr;
    
	strncpy(charArray, cstr, arrayLength);
	
	// ensure there's a null-term on the end (may not be if we concatenated the string)
	charArray[arrayLength-1] = '\0';
}

void StringToStdString(STRINGOBJ bmdStr, std::string& stdStr)
{
	_bstr_t     myBStr(bmdStr); // copies bmdStr, does not take ownership as myBStr autoreleases
	stdStr = myBStr;    
}
